<?php
namespace App\POS;

use App\Core\Database;

class PosAuditService
{
    public function log(
        string $action,
        ?int $referenceId = null,
        ?string $referenceType = null,
        ?string $message = null
    )
    {
        Database::execute(
            "INSERT INTO pos_transaction_logs
            (branch_id, employee_id, action, reference_id, reference_type, message, ip_address, created_at)
            VALUES (?, ?, ?, ?, ?, ?, ?, NOW())",
            [
                $_SESSION['branch_id'] ?? null,
                $_SESSION['employee']['id'] ?? null,
                $action,
                $referenceId,
                $referenceType,
                $message,
                $_SERVER['REMOTE_ADDR'] ?? null
            ]
        );
    }
}
