<?php
namespace App\POS;

class PosAuthorizationService
{
    public function can(string $permission): bool
    {
        $role = $_SESSION['employee']['role'] ?? 'cashier';

        $permissions = [

            'cashier' => [
                'checkout',
                'suspend',
            ],

            'manager' => [
                'checkout',
                'suspend',
                'restore_suspend',
                'cancel_suspend',
                'set_discount',
                'change_salesperson',
                'view_suspended'
            ]

        ];

        return in_array($permission, $permissions[$role] ?? []);
    }
}
