<?php
namespace App\Reports\Controllers;

use App\Core\Database;
use App\Core\Auth;

class ReportController extends \App\Core\BaseController
{
    public function index()
    {
        $this->requireLogin();
$this->requirePermission('report_access');


        $branchId = $_SESSION['branch_id'];

        // Daily sales report (branch-based)
        $sales = Database::fetchAll(
            "SELECT 
                DATE(created_at) AS sale_date,
                SUM(total) AS total_sales,
                COUNT(*) AS total_transactions
             FROM pos_sales
             WHERE branch_id = ?
             GROUP BY DATE(created_at)
             ORDER BY sale_date DESC",
            [$branchId]
        );

        require __DIR__ . '/../../../resources/views/reports/index.php';
    }
}
