<?php
session_start();

require_once __DIR__ . '/app/Core/AppBootstrap.php';

use App\Core\Auth;

/* ================= ROUTE RESOLUTION ================= */
$path   = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$path   = str_replace('/index.php', '', $path);
$path   = trim($path, '/');
$method = $_SERVER['REQUEST_METHOD'];

/* =====================================================
   POS RECEIPT (DYNAMIC ROUTE)
===================================================== */
if (preg_match('#^pos/receipt/(\d+)$#', $path, $matches)) {
    $_GET['id'] = $matches[1];
    (new App\POS\Controllers\PosController())->receipt();
    exit;
}

/* ================= ROUTER ================= */
switch ($path) {

    /* ===== AUTH ===== */
    case 'login':
        (new App\Employees\Controllers\EmployeeController())->loginForm();
        exit;

    case 'auth':
        (new App\Employees\Controllers\EmployeeController())->login();
        exit;

    case 'logout':
        Auth::logout();
        header('Location: /login');
        exit;

    /* ===== ADMIN ===== */
    case 'admin/roles':
        (new App\Admin\Controllers\RoleController())->index();
        exit;

    case 'admin/roles/create':
        (new App\Admin\Controllers\RoleController())->create();
        exit;

    case 'admin/roles/store':
        if ($method === 'POST') {
            (new App\Admin\Controllers\RoleController())->store();
        }
        exit;

    case 'admin/roles/edit':
        (new App\Admin\Controllers\RoleController())->edit();
        exit;

    case 'admin/roles/update':
        if ($method === 'POST') {
            (new App\Admin\Controllers\RoleController())->update();
        }
        exit;

    /* ===== POS ===== */
    case 'pos':
        (new App\POS\Controllers\PosController())->index();
        exit;

    case 'pos/scan-ajax':
        (new App\POS\Controllers\PosController())->scanAjax();
        exit;

    case 'pos/update-qty-ajax':
        (new App\POS\Controllers\PosController())->updateQtyAjax();
        exit;

    case 'pos/remove-item-ajax':
        (new App\POS\Controllers\PosController())->removeItemAjax();
        exit;

    case 'pos/select-customer':
        (new App\POS\Controllers\PosController())->selectCustomer();
        exit;

    case 'pos/checkout':
        (new App\POS\Controllers\PosController())->checkout();
        exit;

    case 'pos/sales':
        (new App\POS\Controllers\PosController())->salesHistory();
        exit;

    case 'pos/change-salesperson':
        (new App\POS\Controllers\PosController())->changeSalesperson();
        exit;

    case 'pos/remove-customer':
        (new App\POS\Controllers\PosController())->removeCustomer();
        exit;

    case 'pos/quick-add-ajax':
        (new App\POS\Controllers\PosController())->quickAddAjax();
        exit;

    case 'pos/set-mode':
        (new App\POS\Controllers\PosController())->setMode();
        exit;

    case 'pos/products-grid':
        (new App\POS\Controllers\PosController())->productsGrid();
        exit;

    case 'pos/cancel-sale':
        (new App\POS\Controllers\PosController())->cancelSale();
        exit;

    case 'pos/suspend-sale':
        (new App\POS\Controllers\PosController())->suspendSale();
        exit;

    case 'pos/suspended-list':
        (new App\POS\Controllers\PosController())->listSuspended();
        exit;

    case 'pos/restore-suspended':
        (new App\POS\Controllers\PosController())->restoreSuspended();
        exit;

    case 'pos/cancel-suspended':
        (new App\POS\Controllers\PosController())->cancelSuspended();
        exit;

    /* ===== CUSTOMERS ===== */
    case 'customers':
        (new App\Customers\Controllers\CustomerController())->index();
        exit;

    case 'customers/view':
        (new App\Customers\Controllers\CustomerController())->view();
        exit;

    case 'customers/ajax-search':
        (new App\Customers\Controllers\CustomerController())->ajaxSearch();
        exit;

    case 'customers/add-ajax':
        (new App\Customers\Controllers\CustomerController())->addAjax();
        exit;

    /* ===== WORK ORDERS ===== */
    case 'work-orders':
        (new App\WorkOrders\Controllers\WorkOrderController())->index();
        exit;

    case 'work-orders/create':
        (new App\WorkOrders\Controllers\WorkOrderController())->create();
        exit;

    case 'work-orders/store':
        if ($method === 'POST') {
            (new App\WorkOrders\Controllers\WorkOrderController())->store();
        }
        exit;

    case 'work-orders/view':
        (new App\WorkOrders\Controllers\WorkOrderController())->view();
        exit;

    case 'work-orders/update':
        if ($method === 'POST') {
            (new App\WorkOrders\Controllers\WorkOrderController())->update();
        }
        exit;

    case 'work-orders/print':
        (new App\WorkOrders\Controllers\WorkOrderController())->print();
        exit;

    /* ===== INVENTORY ===== */
    case 'inventory':
        (new App\Inventory\Controllers\InventoryManageController())->index();
        exit;

    case 'inventory/create':
        (new App\Inventory\Controllers\InventoryManageController())->create();
        exit;

    case 'inventory/store':
        if ($method === 'POST') {
            (new App\Inventory\Controllers\InventoryManageController())->store();
        }
        exit;

    case 'inventory/edit':
        (new App\Inventory\Controllers\InventoryManageController())->edit();
        exit;

    case 'inventory/update':
        if ($method === 'POST') {
            (new App\Inventory\Controllers\InventoryManageController())->update();
        }
        exit;

    case 'inventory/delete':
        (new App\Inventory\Controllers\InventoryManageController())->delete();
        exit;

    /* ===== REPORTS ===== */
    case 'reports':
        (new App\Reports\Controllers\ReportController())->index();
        exit;

    /* ===== AUDIT ===== */
    case 'audit':
        (new App\Audit\Controllers\AuditController())->index();
        exit;

    /* ===== DEFAULT ===== */
    case '':
        header('Location: /pos');
        exit;

    default:
        http_response_code(404);
        require __DIR__ . '/resources/views/errors/404.php';
        exit;
}
