<?php
use App\Core\Database;
use App\Core\Branch;

$branches = Database::fetchAll("SELECT * FROM branches WHERE active = 1");
$currentBranch = Branch::currentId();
?>
<!DOCTYPE html>
<html>
<head>
<title>Repair CRM</title>
<style>
body { font-family: Arial, sans-serif; margin:0; background:#f5f5f5; }
header { background:#222; color:#fff; padding:10px; }
nav a { color:#fff; margin-right:15px; text-decoration:none; }
.container { padding:20px; }
select { margin-left:15px; }
</style>
</head>
<body>

<header>
<strong>Repair CRM</strong>

<form method="post" action="/branch/switch" style="display:inline;">
<select name="branch_id" onchange="this.form.submit()">
<?php foreach ($branches as $b): ?>
<option value="<?php echo $b['id']; ?>" <?php if($b['id']==$currentBranch) echo 'selected'; ?>>
<?php echo htmlspecialchars($b['name']); ?>
</option>
<?php endforeach; ?>
</select>
</form>

<nav>
<a href="/pos">POS</a>
<a href="/work-orders">Work Orders</a>
<a href="/customers">Customers</a>
<a href="/inventory">Inventory</a>
<a href="/reports">Reports</a>
<a href="/audit">Audit</a>
<a href="/logout">Logout</a>
</nav>
</header>

<div class="container">
<?php echo $content; ?>
</div>

</body>
</html>
