<?php
use App\Core\Auth;

$currentPath = trim(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH), '/');
$employee = $_SESSION['employee'] ?? null;

/* Detect Sales-like screens */
$isSalesScreen = ($currentPath === 'pos' || $currentPath === 'pos/receiving');

/* Calculate cart count once */
$cartCount = 0;
if (!empty($_SESSION['pos_cart']['items'])) {
    foreach ($_SESSION['pos_cart']['items'] as $ci) {
        $cartCount += (int)$ci['qty'];
    }
}

/* Breadcrumb title */
$segments = explode('/', $currentPath);
$pageTitle = ucfirst($segments[1] ?? 'Sales');
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Repair CRM</title>

    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="/public/assets/css/layout.css">
    <link rel="stylesheet" href="/public/assets/css/pos.css">
</head>
<body>

<!-- ================= SIDEBAR ================= -->
<div class="pos-sidebar">

    <div class="pos-logo">CRM</div>

    <?php if (Auth::hasPermission('pos_access')): ?>
    <a href="/pos" class="<?= $currentPath === 'pos' ? 'active' : '' ?>">
        <i class="fa-solid fa-cash-register"></i>
        <span class="label">Sales</span>
    </a>
    <?php endif; ?>

    <?php if (Auth::hasPermission('pos_access')): ?>
    <a href="/pos/sales" class="<?= $currentPath === 'pos/sales' ? 'active' : '' ?>">
        <i class="fa-solid fa-receipt"></i>
        <span class="label">Sales History</span>
    </a>
    <?php endif; ?>

    <?php if (Auth::hasPermission('work_orders_access')): ?>
    <a href="/work-orders" class="<?= str_starts_with($currentPath,'work-orders') ? 'active' : '' ?>">
        <i class="fa-solid fa-screwdriver-wrench"></i>
        <span class="label">Work Orders</span>
    </a>
    <?php endif; ?>

    <?php if (Auth::hasPermission('customers_access')): ?>
    <a href="/customers" class="<?= str_starts_with($currentPath,'customers') ? 'active' : '' ?>">
        <i class="fa-solid fa-users"></i>
        <span class="label">Customers</span>
    </a>
    <?php endif; ?>

    <?php if (Auth::hasPermission('inventory_access')): ?>
    <a href="/inventory" class="<?= str_starts_with($currentPath,'inventory') ? 'active' : '' ?>">
        <i class="fa-solid fa-boxes-stacked"></i>
        <span class="label">Inventory</span>
    </a>
    <?php endif; ?>

    <?php if (Auth::hasPermission('reports_access')): ?>
    <a href="/reports" class="<?= str_starts_with($currentPath,'reports') ? 'active' : '' ?>">
        <i class="fa-solid fa-chart-line"></i>
        <span class="label">Reports</span>
    </a>
    <?php endif; ?>

    <?php if (Auth::hasPermission('audit_access')): ?>
    <a href="/audit" class="<?= str_starts_with($currentPath,'audit') ? 'active' : '' ?>">
        <i class="fa-solid fa-clipboard-list"></i>
        <span class="label">Audit</span>
    </a>
    <?php endif; ?>

    <?php if (Auth::hasPermission('admin_manage_roles')): ?>
    <a href="/admin/roles" class="<?= str_starts_with($currentPath,'admin/roles') ? 'active' : '' ?>">
        <i class="fa-solid fa-user-shield"></i>
        <span class="label">Role Management</span>
    </a>
    <?php endif; ?>

    <a href="/logout">
        <i class="fa-solid fa-right-from-bracket"></i>
        <span class="label">Logout</span>
    </a>

</div>

<!-- ================= MAIN ================= -->
<div class="pos-wrapper">

    <!-- ================= HEADER ================= -->
    <div class="pos-header">

        <div class="breadcrumb">
            Dashboard /
            <strong><?= $pageTitle ?></strong>
        </div>

        <div class="header-right">

            <span class="header-time">
                <?= date('H:i d-m-Y') ?>
            </span>

            <?php if ($isSalesScreen): ?>

                <!-- Fullscreen -->
                <span class="icon-btn" id="fullscreenBtn" title="Fullscreen">
                    <i class="fas fa-expand"></i>
                </span>

                <!-- Cart -->
                <span class="icon-btn with-badge" title="Cart">
                    <i class="fas fa-shopping-cart"></i>
                    <span 
                        class="badge" 
                        id="cartCountBadge" 
                        <?= $cartCount > 0 ? '' : 'style="display:none;"' ?>
                    >
                        <?= $cartCount ?>
                    </span>
                </span>

            <?php endif; ?>

            <!-- Notifications -->
            <span class="icon-btn with-badge" title="Notifications">
                <i class="fas fa-bell"></i>
            </span>

            <!-- User Dropdown -->
            <div class="user-dropdown">
                <div class="user-btn">
                    <i class="fas fa-user-circle"></i>
                    <span class="user-name">
                        <?= htmlspecialchars($employee['name'] ?? 'User') ?>
                    </span>
                </div>

                <div class="dropdown-menu">
                    <a href="#">Profile</a>
                    <a href="#">Settings</a>
                    <a href="#">Changelog</a>
                    <a href="/logout">Logout</a>
                </div>
            </div>

        </div>
    </div>

    <!-- ================= CONTENT ================= -->
    <div class="pos-content">
        <?= $content ?>
    </div>

</div>

<script>
/* Fullscreen */
document.getElementById('fullscreenBtn')?.addEventListener('click', function(){
    if (!document.fullscreenElement) {
        document.documentElement.requestFullscreen();
    } else {
        document.exitFullscreen();
    }
});

/* Dropdown */
document.querySelector('.user-btn')?.addEventListener('click', function(){
    document.querySelector('.dropdown-menu').classList.toggle('show');
});
</script>

</body>
</html>
