<?php
$cart = $_SESSION['pos_cart'] ?? ['items' => [], 'total' => 0];
$selectedCustomer = $_SESSION['pos_customer'] ?? null;
?>

<div class="pos-body">
    <input type="hidden" id="checkoutToken" value="<?= $_SESSION['checkout_token']
 ?>">

    <!-- ================= CENTER ================= -->
    <div class="pos-center">

        <div class="scan-bar">

    <button class="scan-btn add-product">
        <i class="fas fa-plus"></i>
    </button>

    <input type="text"
           id="barcode-input"
           placeholder="Enter item name or scan barcode"
           autocomplete="off">

    <button class="scan-btn sale-mode">
        <i class="fas fa-shopping-cart"></i> Sale
    </button>

    <button class="scan-btn show-grid">
        <i class="fas fa-th-large"></i> Show Grid
    </button>

</div>

        <div class="cart-header">
            <div></div>
            <div>Item</div>
            <div>Price</div>
            <div>Qty</div>
            <div>Total</div>
        </div>

        <div id="cartBody">
            <?php if (!empty($cart['items'])): ?>
                <?php foreach ($cart['items'] as $i => $item): ?>
                    <div class="cart-row">
                        <div>
                            <button type="button" class="remove-item" data-index="<?= $i ?>">✖</button>
                        </div>
                        <div><?= htmlspecialchars($item['name']) ?></div>
                        <div><?= number_format($item['price'],2) ?></div>
                        <div>
                            <button type="button" class="qty-btn" data-action="dec" data-index="<?= $i ?>">−</button>
                            <span class="qty"><?= $item['qty'] ?></span>
                            <button type="button" class="qty-btn" data-action="inc" data-index="<?= $i ?>">+</button>
                        </div>
                        <div><?= number_format($item['price'] * $item['qty'],2) ?></div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="cart-empty">
                    There are no items in the cart <strong>[Sales]</strong>
                </div>
            <?php endif; ?>
        </div>

    </div>


    <!-- ================= RIGHT ================= -->
    <div class="pos-right">

<!-- ACTION + CUSTOMER (Single Card Like PHP POS) -->
<div class="pos-card action-customer-card">

<?php
$hasItems = !empty($cart['items']);
$hasCustomer = !empty($selectedCustomer);
?>

    <div class="action-top <?= !$hasItems ? 'only-menu' : '' ?>">

        <!-- DROPDOWN MENU BUTTON -->
        <div class="action-menu-wrapper">
            <button class="icon-square" id="actionMenuBtn">
                <i class="fas fa-ellipsis-h"></i>
            </button>

            <div class="action-dropdown" id="actionDropdown">
                <button class="dropdown-item show-suspended">
                    <i class="fas fa-layer-group"></i>
                    Suspended Sales
                </button>

                <button class="dropdown-item">
                    <i class="fas fa-chart-line"></i>
                    Sales History
                </button>

                <button class="dropdown-item">
                    <i class="fas fa-cog"></i>
                    Settings
                </button>
            </div>
        </div>

        <button class="btn-cancel hidden-btn" id="cancelBtn">
            <i class="fas fa-times"></i>
            <span>Cancel Sale</span>
        </button>

        <button class="btn-suspend hidden-btn" id="suspendBtn">
            <i class="fas fa-pause"></i>
            <span>Suspend Sale</span>
        </button>

    </div>

    <div class="divider"></div>

    <?php if ($hasCustomer): ?>

        <!-- CUSTOMER PROFILE (PHP POS STYLE) -->
        <div class="customer-profile-premium">

            <div class="customer-avatar-premium">
                <i class="fas fa-user"></i>
            </div>

            <div class="customer-details-premium">
                <div class="customer-name">
                    <?= htmlspecialchars($selectedCustomer['name']) ?>
                </div>
                <?php if (!empty($selectedCustomer['phone'])): ?>
                    <div class="customer-phone">
                        <?= htmlspecialchars($selectedCustomer['phone']) ?>
                    </div>
                <?php endif; ?>
            </div>

        </div>

        <!-- CUSTOMER ACTION BUTTONS (LIKE PHP POS) -->
        <div class="customer-actions">

            <button class="customer-action-btn delivery-btn">
                <i class="fas fa-truck"></i>
                Delivery
            </button>

            <button class="customer-action-btn update-btn">
                <i class="fas fa-edit"></i>
                Update
            </button>

            <button class="customer-action-btn detach-btn">
                <i class="fas fa-times"></i>
                Detach
            </button>

        </div>

    <?php else: ?>

        <div class="customer-search-modern">
            <div class="customer-icon-box">
                <i class="fas fa-user-plus"></i>
            </div>
            <input type="text"
                   id="customerSearch"
                   placeholder="Type customer name..."
                   autocomplete="off">
            <div id="customerDropdown" class="dropdown"></div>
        </div>

    <?php endif; ?>

</div>




        <!-- ================= SUMMARY ================= -->
        <div class="pos-card summary-card">

            <div class="meta-row">
                <span>Item Tiers:</span>
                <span>None</span>
            </div>

            <div class="sales-section">

                <div class="meta-row sales-header">
                    <span>Sales person:</span>
                    <span id="currentSalesPerson"
                          class="sales-person-name"
                          data-id="<?= $currentSalespersonId ?>">
                        <?php
                        foreach ($employees as $emp) {
                            if ($emp['id'] == $currentSalespersonId) {
                                echo htmlspecialchars($emp['name']);
                                break;
                            }
                        }
                        ?>
                    </span>
                </div>

                <div id="salesPersonList" class="sales-person-list">
                    <?php foreach ($employees as $emp): ?>
                        <div class="sales-person-option <?= $emp['id'] == $currentSalespersonId ? 'active' : '' ?>"
                             data-id="<?= $emp['id'] ?>">
                            <?= htmlspecialchars($emp['name']) ?>
                        </div>
                    <?php endforeach; ?>
                </div>

            </div>

            <div class="meta-row">
                <span>Discount all Items by Percent:</span>
                <a href="#" class="meta-link">Set Discount</a>
            </div>

            <div class="meta-row">
                <span>Discount Entire Sale:</span>
                <a href="#" class="meta-link">Set Discount</a>
            </div>

            <div class="subtotal-strip">
                <span>Sub Total</span>
                <span id="cartSubtotal">RM <?= number_format($cart['total'],2) ?></span>
            </div>

            <div class="total-grid">
                <div class="total-box">
                    <div>Total</div>
                    <div class="amount green" id="cartTotal">
                        RM <?= number_format($cart['total'],2) ?>
                    </div>
                </div>

                <div class="total-box">
                    <div>Amount Due</div>
                    <div class="amount orange" id="cartDue">
                        RM <?= number_format($cart['total'],2) ?>
                    </div>
                </div>
            </div>

            <div id="paymentSection"
                 style="<?= empty($cart['items']) ? 'display:none;' : '' ?>">

                <div class="divider"></div>

                <div class="payment-title">Add Payment</div>

                <div class="payment-methods-modern">
                    <button type="button" class="pay-btn" data-method="cash">Cash</button>
                    <button type="button" class="pay-btn" data-method="card">Card</button>
                </div>

                <div id="cashBox" class="cash-box" style="display:none;">
                    <input type="number" id="cashTendered"
                           step="0.01"
                           placeholder="Amount tendered">
                </div>

                <button id="checkoutBtn" class="btn-complete">
                    Complete Sale
                </button>
                
            </div>
            
        </div>

    </div>

</div>

<!-- ================= SUSPEND MODAL ================= -->
<div id="suspendModal" class="modal-overlay hidden">
    <div class="modal-container">

        <div class="modal-header">
            <h2>Suspended Sales</h2>
            <button class="modal-close" id="closeSuspendModal">&times;</button>
        </div>

        <div class="modal-search">
            <input type="text" id="suspendSearch" placeholder="Search reference / customer...">
        </div>

        <div class="modal-body">
            <table class="suspend-table">
                <thead>
                    <tr>
                        <th>Reference</th>
                        <th>Customer</th>
                        <th>Salesperson</th>
                        <th>Total</th>
                        <th>Note</th>
                        <th>Date</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody id="suspendTableBody">
                    <!-- Dynamic -->
                </tbody>
            </table>
        </div>

    </div>
    
</div>
<!-- ================= ERROR MODAL ================= -->
<div id="errorModal" class="modal hidden">
    <div class="modal-box">
        <div class="modal-header">
            <h3>Stock Error</h3>
        </div>
        <div class="modal-body">
            <p id="errorMessage"></p>
        </div>
        <div class="modal-footer">
            <button id="closeErrorModal" class="btn-primary">OK</button>
        </div>
    </div>
</div>

<script>
    window.initialCart = <?= json_encode($cart); ?>;
</script>

<script src="/public/assets/js/pos.js"></script>
